/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.debug;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugHelpers;
import org.squiddev.cobalt.debug.ObjectName;
import org.squiddev.cobalt.debug.Upvalue;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;

public final class DebugFrame {
    public static final int FLAG_JAVA_STACK = 1;
    public static final int FLAG_FRESH = 2;
    public static final int FLAG_TAIL = 4;
    public static final int FLAG_YPCALL = 8;
    public static final int FLAG_ERROR = 16;
    public static final int FLAG_LEQ = 32;
    public static final int FLAG_INTERRUPTED = 64;
    static final int FLAG_CALL_HOOK = 1024;
    static final int FLAG_RETURN_HOOK = 2048;
    public static final int FLAG_INSN_HOOK = 4096;
    public static final int FLAG_LINE_HOOK = 8192;
    public static final int FLAG_ANY_HOOK = 15360;
    public LuaFunction func;
    public LuaClosure closure;
    public LuaValue[] stack;
    public Upvalue lastUpvalue;
    public Object state;
    public final DebugFrame previous;
    private static final LuaString TEMPORARY = ValueFactory.valueOf("(*temporary)");
    public Varargs varargs;
    public Varargs extras;
    public int pc = -1;
    public int oldPc = -1;
    public int top = -1;
    public int flags;

    DebugFrame(DebugFrame previous) {
        this.previous = previous;
        this.func = null;
    }

    public void cleanup() {
        for (Upvalue upvalue = this.lastUpvalue; upvalue != null; upvalue = upvalue.close()) {
        }
    }

    void clear() {
        this.func = null;
        this.closure = null;
        this.stack = null;
        this.lastUpvalue = null;
        this.state = null;
        this.extras = null;
        this.varargs = null;
        this.flags = 0;
        this.top = -1;
        this.pc = -1;
        this.oldPc = -1;
    }

    public void closeUpvalues(int until) {
        Upvalue upvalue;
        for (upvalue = this.lastUpvalue; upvalue != null && upvalue.getIndex() >= until; upvalue = upvalue.close()) {
        }
        this.lastUpvalue = upvalue;
    }

    public Upvalue getUpvalue(int slot) {
        Upvalue upvalue = this.lastUpvalue;
        Upvalue next = null;
        while (upvalue != null) {
            if (upvalue.getIndex() == slot) {
                return upvalue;
            }
            if (upvalue.getIndex() < slot) break;
            next = upvalue;
            upvalue = next.previous;
        }
        Upvalue newUpvalue = new Upvalue(this.stack, slot, upvalue);
        if (next == null) {
            this.lastUpvalue = newUpvalue;
        } else {
            next.previous = newUpvalue;
        }
        return newUpvalue;
    }

    public int currentLine() {
        if (this.closure == null) {
            return -1;
        }
        int[] li = this.closure.getPrototype().lineInfo;
        return li == null || this.pc < 0 || this.pc >= li.length ? -1 : li[this.pc];
    }

    public @Nullable ObjectName getFuncKind() {
        DebugFrame previous = this.previous;
        if ((this.flags & 4) != 0) {
            return null;
        }
        if (previous == null || previous.closure == null || previous.pc < 0) {
            return null;
        }
        int stackpos = previous.closure.getPrototype().code[previous.pc] >> 6 & 0xFF;
        return DebugHelpers.getFuncName(previous, stackpos);
    }

    public @Nullable String sourceLine() {
        return this.closure == null ? null : String.valueOf(this.closure.getPrototype().shortSource()) + ":" + this.currentLine();
    }

    public LuaString getLocalName(int index) {
        if (this.closure == null) {
            return null;
        }
        LuaString name = this.closure.getPrototype().getLocalName(index, this.pc);
        if (name != null) {
            return name;
        }
        return index > 0 && index <= this.closure.getPrototype().maxStackSize ? TEMPORARY : null;
    }
}

